/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import com.google.common.collect.Lists;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.adventurez.block.ShadowChest;
import net.adventurez.entity.VoidFragmentEntity;
import net.adventurez.entity.VoidShadeEntity;
import net.adventurez.entity.nonliving.ThrownRockEntity;
import net.adventurez.entity.nonliving.VoidCloudEntity;
import net.adventurez.init.BlockInit;
import net.adventurez.init.EffectInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.SoundInit;
import net.adventurez.init.TagInit;
import net.adventurez.network.AdventureServerPacket;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.voidz.block.VoidStoneBlock;
import net.voidz.block.entity.PortalBlockEntity;
import net.voidz.init.DimensionInit;
import org.jetbrains.annotations.Nullable;

public class VoidShadowEntity
extends FlyingMob
implements Enemy {
    public static final EntityDataAccessor<Boolean> HALF_LIFE_CHANGE = SynchedEntityData.m_135353_(VoidShadowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> IS_THROWING_BLOCKS = SynchedEntityData.m_135353_(VoidShadowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> HOVERING_MAGIC_HANDS = SynchedEntityData.m_135353_(VoidShadowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> CIRCLING_HANDS = SynchedEntityData.m_135353_(VoidShadowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private List<BlockPos> blockPosList = new ArrayList<BlockPos>();
    private final ServerBossEvent bossBar = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
    private boolean circling;
    private boolean wasCircling;
    private int portalX;
    private int portalY;
    private int portalZ;
    private boolean isHalfLife;
    private final boolean isInVoidDungeon;
    private boolean invisible;
    public int ticksSinceDeath;

    public VoidShadowEntity(EntityType<? extends FlyingMob> entityType, Level world) {
        super(entityType, world);
        this.f_21364_ = 100;
        this.f_21342_ = new VoidShadowMoveControl(this);
        this.isInVoidDungeon = FabricLoader.getInstance().isModLoaded("voidz") && world.m_46472_() == DimensionInit.VOID_WORLD;
    }

    public void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new ThrowBlocks(this));
        this.f_21345_.m_25352_(1, (Goal)new DestroyBlocksAttack(this));
        this.f_21345_.m_25352_(2, (Goal)new SummonFragment(this));
        this.f_21345_.m_25352_(3, (Goal)new SummonShade(this));
        this.f_21345_.m_25352_(4, (Goal)new Insanity(this));
        this.f_21345_.m_25352_(6, (Goal)new FlyGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new LookGoal(this));
    }

    public static AttributeSupplier.Builder createVoidShadowAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22279_, 0.1).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22282_, 2.0).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22278_, 10.0).m_22268_(Attributes.f_22277_, 80.0);
    }

    public void m_8024_() {
        super.m_8024_();
        this.bossBar.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.m_21223_() < this.m_21233_() / 2.0f) {
            if (!((Boolean)this.f_19804_.m_135370_(HALF_LIFE_CHANGE)).booleanValue()) {
                this.f_19804_.m_135381_(HALF_LIFE_CHANGE, (Object)true);
            }
            if (!this.isHalfLife) {
                this.m_21051_(Attributes.f_22282_).m_22100_(6.0);
                this.m_21051_(Attributes.f_22281_).m_22100_(14.0);
                this.m_21051_(Attributes.f_22284_).m_22100_(4.0);
                this.isHalfLife = true;
            }
            if (this.m_21223_() < this.m_21233_() / 8.0f && !this.invisible) {
                this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 400, 0, false, false, false));
                this.invisible = true;
            }
        }
    }

    public void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HALF_LIFE_CHANGE, (Object)false);
        this.f_19804_.m_135372_(IS_THROWING_BLOCKS, (Object)false);
        this.f_19804_.m_135372_(HOVERING_MAGIC_HANDS, (Object)false);
        this.f_19804_.m_135372_(CIRCLING_HANDS, (Object)false);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("VoidXPortal", this.portalX);
        tag.m_128405_("VoidYPortal", this.portalY);
        tag.m_128405_("VoidZPortal", this.portalZ);
        tag.m_128379_("ShadowCircling", this.circling);
        tag.m_128379_("ShadowIsHalfLife", this.isHalfLife);
        tag.m_128408_("ShadowBrokenBlocks", this.blockListTransform(this.blockPosList));
        tag.m_128379_("ShadowInvisible", this.invisible);
        tag.m_128379_("ShadowWasCircling", this.wasCircling);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (this.m_8077_()) {
            this.bossBar.m_6456_(this.m_5446_());
        }
        this.portalX = tag.m_128451_("VoidXPortal");
        this.portalY = tag.m_128451_("VoidYPortal");
        this.portalZ = tag.m_128451_("VoidZPortal");
        this.circling = tag.m_128471_("ShadowCircling");
        this.isHalfLife = tag.m_128471_("ShadowIsHalfLife");
        this.setBlockList(tag.m_128465_("ShadowBrokenBlocks"));
        this.invisible = tag.m_128471_("ShadowInvisible");
        this.wasCircling = tag.m_128471_("ShadowWasCircling");
        if (!this.circling && this.wasCircling) {
            this.circling = true;
        }
    }

    private List<Integer> blockListTransform(List<BlockPos> oldBlockPosList) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < oldBlockPosList.size(); ++i) {
            list.add(oldBlockPosList.get(i).m_123341_());
            list.add(oldBlockPosList.get(i).m_123342_());
            list.add(oldBlockPosList.get(i).m_123343_());
        }
        return list;
    }

    private void setBlockList(int[] integers) {
        if (integers.length != 0) {
            for (int i = 0; i < integers.length; ++i) {
                if (i % 3 != 0) continue;
                this.blockPosList.add(i / 3, new BlockPos(integers[i], integers[i + 1], integers[i + 2]));
            }
        }
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossBar.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossBar.m_6543_(player);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData, @Nullable CompoundTag entityTag) {
        if (!this.hasVoidMiddleCoordinates() && FabricLoader.getInstance().isModLoaded("voidz") && world.m_8055_(this.m_20183_().m_7495_()).m_60734_() == net.voidz.init.BlockInit.PORTAL) {
            this.setVoidMiddle(this.m_20183_().m_123341_(), this.m_20183_().m_123342_(), this.m_20183_().m_123343_());
        }
        return super.m_6518_(world, difficulty, spawnReason, entityData, entityTag);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossBar.m_6539_(player);
    }

    public boolean m_6785_(double num) {
        return false;
    }

    public void m_6043_() {
        if (this.m_9236_().m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean m_147207_(MobEffectInstance effect, Entity entity) {
        return false;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return false;
    }

    private boolean hasVoidMiddleCoordinates() {
        return this.portalX != 0 || this.portalY != 0 || this.portalZ != 0;
    }

    public void setVoidMiddle(int x, int y, int z) {
        this.circling = true;
        this.portalX = x;
        this.portalY = y;
        this.portalZ = z;
    }

    public BlockPos getVoidMiddle() {
        return new BlockPos(this.portalX, this.portalY, this.portalZ);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof LivingEntity && !(source.m_7639_() instanceof VoidFragmentEntity)) {
            if (this.circling) {
                this.m_6710_((LivingEntity)source.m_7639_());
            }
            amount *= 0.5f;
            ((LivingEntity)source.m_7639_()).m_147240_(4.0, this.m_20185_() - source.m_7639_().m_20185_(), this.m_20189_() - source.m_7639_().m_20189_());
            ((LivingEntity)source.m_7639_()).m_6469_(this.m_269291_().m_269425_(), 1.0f);
        }
        if (source.m_7640_() instanceof ThrownRockEntity) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_) && source.m_7640_() instanceof Arrow) {
            Arrow arrowEntity = (Arrow)source.m_7640_();
            if (arrowEntity.m_142038_()) {
                return true;
            }
            source.m_7640_().m_146870_();
            return false;
        }
        return this.m_6673_(source) ? false : super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource source) {
        if (!this.m_9236_().m_5776_() && !this.blockPosList.isEmpty()) {
            for (int u = 0; u < this.blockPosList.size(); ++u) {
                this.m_9236_().m_46597_(this.blockPosList.get(u), net.voidz.init.BlockInit.VOID_STONE.m_49966_());
                this.m_9236_().m_5594_(null, this.blockPosList.get(u), SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
        super.m_6667_(source);
    }

    protected SoundEvent m_7515_() {
        return SoundInit.SHADOW_IDLE_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.SHADOW_DEATH_EVENT;
    }

    protected float m_6121_() {
        return 5.0f;
    }

    private void deathParticles(ParticleOptions particleEffect) {
        float f = (this.f_19796_.m_188501_() - 0.5f) * 16.0f;
        float g = (this.f_19796_.m_188501_() - 0.5f) * 10.0f;
        float h = (this.f_19796_.m_188501_() - 0.5f) * 16.0f;
        this.m_9236_().m_7106_(particleEffect, this.m_20185_() + (double)f, this.m_20186_() + 2.0 + (double)g, this.m_20189_() + (double)h, 0.0, 0.0, 0.0);
    }

    protected void m_6153_() {
        int i;
        ++this.ticksSinceDeath;
        this.m_21557_(true);
        this.m_6710_(null);
        if (this.m_9236_().m_5776_()) {
            if (this.ticksSinceDeath >= 0 && this.ticksSinceDeath < 40) {
                for (i = 0; i < 10; ++i) {
                    this.deathParticles((ParticleOptions)ParticleTypes.f_123760_);
                }
            }
            if (this.ticksSinceDeath >= 41 && this.ticksSinceDeath <= 200) {
                this.deathParticles((ParticleOptions)ParticleTypes.f_123787_);
            }
        }
        if (!this.m_9236_().m_5776_()) {
            this.bossBar.m_142711_(0.0f);
            if (this.ticksSinceDeath == 1 && !this.m_20067_()) {
                this.m_9236_().m_6798_(1028, this.m_20183_(), 0);
            }
            if (this.hasVoidMiddleCoordinates() && this.ticksSinceDeath == 40) {
                this.m_20324_(this.getVoidMiddle().m_123341_(), this.getVoidMiddle().m_6630_(5).m_123342_(), this.getVoidMiddle().m_123343_());
            }
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.05, 0.0));
        if (this.ticksSinceDeath >= 198) {
            for (i = 0; i < 100; ++i) {
                this.deathParticles((ParticleOptions)ParticleTypes.f_123762_);
            }
        }
        if (this.ticksSinceDeath >= 200 && !this.m_9236_().m_5776_()) {
            AABB box = new AABB(this.m_20183_());
            List list = this.m_9236_().m_6443_(Player.class, box.m_82400_(128.0), EntitySelector.f_20408_);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                ((Player)list.get(i2)).m_7292_(new MobEffectInstance(EffectInit.FAME, 48000, 0, false, false, true));
            }
            if (this.isInVoidDungeon) {
                BlockEntity blockEntity;
                boolean direction = this.m_9236_().m_213780_().m_188503_(2) == 0;
                BlockPos pos = direction ? this.getVoidMiddle().m_122013_(3) : this.getVoidMiddle().m_122020_(3);
                BlockState state = (BlockState)BlockInit.SHADOW_CHEST.m_49966_().m_61124_((Property)ShadowChest.FACING, (Comparable)(direction ? Direction.SOUTH : Direction.NORTH));
                this.m_9236_().m_7731_(pos, state, 3);
                state.m_60734_().m_6402_(this.m_9236_(), pos, state, null, ItemStack.f_41583_);
                if (this.m_9236_().m_7702_(this.getVoidMiddle().m_7495_()) != null && (blockEntity = this.m_9236_().m_7702_(this.getVoidMiddle().m_7495_())) instanceof PortalBlockEntity) {
                    PortalBlockEntity portalBlockEntity = (PortalBlockEntity)blockEntity;
                    portalBlockEntity.bossTime = (int)this.m_9236_().m_6106_().m_6793_();
                }
            } else {
                this.m_9236_().m_7731_(this.m_20183_(), Blocks.f_50260_.m_49966_(), 3);
            }
            this.m_146870_();
        }
    }

    static class VoidShadowMoveControl
    extends MoveControl {
        private final VoidShadowEntity voidShadowEntity;

        public VoidShadowMoveControl(VoidShadowEntity voidShadowEntity) {
            super((Mob)voidShadowEntity);
            this.voidShadowEntity = voidShadowEntity;
        }

        public void m_8126_() {
            if (this.voidShadowEntity.circling && this.voidShadowEntity.hasVoidMiddleCoordinates()) {
                BlockPos pos = this.voidShadowEntity.getVoidMiddle();
                Vec3 vec3d = new Vec3((double)pos.m_123341_() - this.voidShadowEntity.m_20185_(), (double)pos.m_123342_() - this.voidShadowEntity.m_20186_(), (double)pos.m_123343_() - this.voidShadowEntity.m_20189_());
                vec3d = vec3d.m_82541_();
                Vec3 distanceVector = new Vec3(this.voidShadowEntity.m_20185_(), this.voidShadowEntity.m_20186_(), this.voidShadowEntity.m_20189_());
                Vec3 vec3 = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                if (distanceVector.m_82554_(vec3) >= 50.0) {
                    this.voidShadowEntity.m_20256_(this.voidShadowEntity.m_20184_().m_82549_(vec3d.m_82490_(0.1)));
                } else {
                    this.voidShadowEntity.m_20256_(this.voidShadowEntity.m_20184_().m_82549_(vec3d.m_82490_(0.1).m_82490_(-1.0)));
                }
                this.voidShadowEntity.m_20256_(this.voidShadowEntity.m_20184_().m_82549_(vec3d.m_82490_(0.1).m_82524_(90.0f)));
                if (this.voidShadowEntity.m_20184_().m_82553_() <= 0.3) {
                    this.voidShadowEntity.m_5997_(0.1, 0.1, 0.1);
                }
            } else if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 vec3d = new Vec3(this.f_24975_ - this.voidShadowEntity.m_20185_(), this.f_24976_ - this.voidShadowEntity.m_20186_(), this.f_24977_ - this.voidShadowEntity.m_20189_());
                vec3d = vec3d.m_82541_();
                this.voidShadowEntity.m_20256_(this.voidShadowEntity.m_20184_().m_82549_(vec3d.m_82490_(0.1)));
            }
        }
    }

    static class ThrowBlocks
    extends Goal {
        private final VoidShadowEntity voidShadow;
        private int throwTicker;
        private int throwBlocks;

        public ThrowBlocks(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.voidShadow.m_5448_();
            if (livingEntity != null && this.voidShadow.circling && this.voidShadow.m_20270_((Entity)livingEntity) > 5.0f && this.voidShadow.m_20270_((Entity)livingEntity) < 30.0f) {
                ++this.throwTicker;
                return this.throwTicker >= 80;
            }
            return false;
        }

        public void m_8037_() {
            LivingEntity livingEntity = this.voidShadow.m_5448_();
            if (livingEntity != null) {
                this.voidShadow.f_21365_.m_24960_((Entity)livingEntity, 1.0f, 1.0f);
                ++this.throwBlocks;
                if (this.throwBlocks >= 10) {
                    BlockPos pos = this.voidShadow.m_20183_();
                    for (int i = 0; i < (this.voidShadow.isHalfLife ? 60 : 40); ++i) {
                        if (this.voidShadow.m_9236_().m_5776_()) continue;
                        double random = this.voidShadow.m_9236_().m_213780_().m_188500_() + 0.3;
                        double anotherRandom = this.voidShadow.m_9236_().m_213780_().m_188500_();
                        double anotherExtraRandom = this.voidShadow.m_9236_().m_213780_().m_188500_() - 0.5;
                        double anotherExtraXXXRandom = this.voidShadow.m_9236_().m_213780_().m_188500_() - 0.5;
                        Block block = this.voidShadow.hasVoidMiddleCoordinates() ? this.voidShadow.m_9236_().m_8055_(this.voidShadow.getVoidMiddle().m_122012_().m_7495_()).m_60734_() : (!this.voidShadow.m_9236_().m_8055_(pos.m_6625_(5)).m_60795_() ? this.voidShadow.m_9236_().m_8055_(pos.m_6625_(5)).m_60734_() : Blocks.f_50069_);
                        ThrownRockEntity thrownRockEntity = new ThrownRockEntity(this.voidShadow.m_9236_(), (LivingEntity)this.voidShadow);
                        Vec3 vec3d = new Vec3(livingEntity.m_20185_() - this.voidShadow.m_20185_(), livingEntity.m_20186_() - this.voidShadow.m_20186_(), livingEntity.m_20189_() - this.voidShadow.m_20189_());
                        vec3d = vec3d.m_82520_(anotherExtraRandom * 12.0, 5.0 * anotherRandom, anotherExtraXXXRandom * 12.0);
                        vec3d = vec3d.m_82541_();
                        thrownRockEntity.m_20256_(thrownRockEntity.m_20184_().m_82549_(vec3d.m_82490_(1.4 * random)));
                        thrownRockEntity.m_37446_(new ItemStack((ItemLike)block.m_5456_()));
                        this.voidShadow.m_9236_().m_7967_((Entity)thrownRockEntity);
                    }
                    this.voidShadow.m_9236_().m_6269_((Player)null, (Entity)this.voidShadow, SoundInit.ROCK_THROW_EVENT, SoundSource.HOSTILE, 1.0f, 1.0f);
                    this.throwBlocks = 0;
                    this.m_8041_();
                }
            }
        }

        public boolean m_8045_() {
            LivingEntity livingEntity = this.voidShadow.m_5448_();
            if (livingEntity == null || !livingEntity.m_6084_()) {
                return false;
            }
            return this.voidShadow.m_20270_((Entity)livingEntity) > 5.0f && this.voidShadow.m_20270_((Entity)livingEntity) < 30.0f && this.throwTicker == 0;
        }

        public void m_8056_() {
            this.voidShadow.f_19804_.m_135381_(IS_THROWING_BLOCKS, (Object)true);
            this.voidShadow.m_21573_().m_26573_();
            this.throwTicker = 0;
        }

        public void m_8041_() {
            this.voidShadow.f_19804_.m_135381_(IS_THROWING_BLOCKS, (Object)false);
            ++this.throwTicker;
        }
    }

    static class DestroyBlocksAttack
    extends Goal {
        private final VoidShadowEntity voidShadow;
        private int canStartTicker;
        private int destroyBlocksTicker;
        private static final TargetingConditions PLAYER_PREDICATE = TargetingConditions.m_148352_().m_26883_(128.0).m_148355_();
        private List<BlockPos> playerBlockPosList = new ArrayList<BlockPos>();

        public DestroyBlocksAttack(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.voidShadow.m_5448_();
            if (livingEntity != null && this.voidShadow.isInVoidDungeon) {
                ++this.canStartTicker;
                return this.canStartTicker >= 200;
            }
            return false;
        }

        public void m_8037_() {
            ++this.destroyBlocksTicker;
            if (this.destroyBlocksTicker == 40 && this.voidShadow.m_5448_() != null) {
                int u;
                AABB box = new AABB(this.voidShadow.m_20183_());
                List playerList = this.voidShadow.m_9236_().m_45955_(PLAYER_PREDICATE, (LivingEntity)this.voidShadow, box.m_82400_(120.0));
                for (int i = 0; i < playerList.size(); ++i) {
                    Player playerEntity = (Player)playerList.get(i);
                    if (playerEntity.m_7500_() || playerEntity.m_5833_()) continue;
                    if (!this.voidShadow.m_9236_().m_8055_(playerEntity.m_20183_().m_7495_()).m_60795_()) {
                        this.playerBlockPosList.add(playerEntity.m_20183_().m_7495_());
                        continue;
                    }
                    if (this.voidShadow.m_9236_().m_8055_(playerEntity.m_20183_().m_6625_(2)).m_60795_()) continue;
                    this.playerBlockPosList.add(playerEntity.m_20183_().m_6625_(2));
                }
                for (u = 0; u < this.playerBlockPosList.size(); ++u) {
                    BlockPos pos = this.playerBlockPosList.get(u);
                    int radius = this.voidShadow.isHalfLife ? 5 : 3;
                    for (int k = -radius; k <= radius; ++k) {
                        for (int i = -radius; i <= radius; ++i) {
                            BlockPos blockPos = pos.m_7918_(k, 0, i).m_7918_(Mth.m_14107_((double)Math.sin(k)) * i, 0, Mth.m_14107_((double)Math.cos(k)) * i);
                            if (this.voidShadow.blockPosList.contains(blockPos) || this.voidShadow.m_9236_().m_8055_(blockPos).m_60795_() || this.voidShadow.m_9236_().m_8055_(blockPos).m_204336_(TagInit.UNBREAKABLE_BLOCKS)) continue;
                            this.voidShadow.blockPosList.add(blockPos);
                        }
                    }
                }
                for (u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                    this.voidShadow.m_9236_().m_46597_(this.voidShadow.blockPosList.get(u), (BlockState)net.voidz.init.BlockInit.VOID_STONE.m_49966_().m_61124_((Property)VoidStoneBlock.ACTIVATED, (Comparable)Boolean.valueOf(true)));
                }
            }
            if (this.destroyBlocksTicker == 110) {
                ((ServerLevel)this.voidShadow.m_9236_()).m_6269_(null, (Entity)this.voidShadow, SoundInit.SHADOW_CAST_EVENT, SoundSource.HOSTILE, 20.0f, 1.0f);
            }
            if (this.destroyBlocksTicker == 120) {
                this.voidShadow.f_19804_.m_135381_(HOVERING_MAGIC_HANDS, (Object)false);
            }
            if (this.destroyBlocksTicker >= 400) {
                this.destroyBlocksTicker = 0;
                this.m_8041_();
            }
        }

        public boolean m_8045_() {
            return this.canStartTicker == 0;
        }

        public void m_8056_() {
            this.voidShadow.f_19804_.m_135381_(HOVERING_MAGIC_HANDS, (Object)true);
            this.canStartTicker = 0;
            ((ServerLevel)this.voidShadow.m_9236_()).m_6269_(null, (Entity)this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, SoundSource.HOSTILE, 20.0f, 1.0f);
        }

        public void m_8041_() {
            ++this.canStartTicker;
            for (int u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                this.voidShadow.m_9236_().m_46597_(this.voidShadow.blockPosList.get(u), net.voidz.init.BlockInit.VOID_STONE.m_49966_());
                this.voidShadow.m_9236_().m_5594_(null, this.voidShadow.blockPosList.get(u), SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            if (!this.voidShadow.blockPosList.isEmpty()) {
                this.voidShadow.blockPosList.clear();
            }
            if (!this.playerBlockPosList.isEmpty()) {
                this.playerBlockPosList.clear();
            }
        }
    }

    static class SummonFragment
    extends Goal {
        private final VoidShadowEntity voidShadow;
        private int summonStartTicker;
        private int summonTick;

        public SummonFragment(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.voidShadow.m_5448_();
            if (this.voidShadow.isInVoidDungeon && this.voidShadow.circling && this.voidShadow.hasVoidMiddleCoordinates() && livingEntity != null) {
                ++this.summonStartTicker;
                if (this.summonStartTicker >= 200) {
                    AABB box = new AABB(this.voidShadow.m_20183_());
                    List list = this.voidShadow.m_9236_().m_6443_(VoidFragmentEntity.class, box.m_82400_(120.0), EntitySelector.f_20408_);
                    if (list.isEmpty() || list.size() < 2) {
                        return true;
                    }
                    this.summonStartTicker = 0;
                }
                return false;
            }
            return false;
        }

        public void m_8037_() {
            ++this.summonTick;
            if (this.summonTick >= 40 && this.voidShadow.m_5448_() != null) {
                BlockPos pos = this.voidShadow.getVoidMiddle();
                Boolean isOrb = this.voidShadow.f_19796_.m_188501_() < 0.35f;
                for (int i = 0; i < (isOrb != false ? 4 : 10); ++i) {
                    if (this.voidShadow.m_9236_().m_5776_()) continue;
                    BlockPos spawnPos = isOrb.booleanValue() ? (i < 2 ? new BlockPos(pos.m_123341_() + 28 * (i - 1), pos.m_123342_(), pos.m_123343_() + 28 * i) : new BlockPos(pos.m_123341_() + 28 * (-i + 3), pos.m_123342_(), pos.m_123343_() + 28 * (-i + 2))) : new BlockPos(pos.m_123341_() - 35 + this.voidShadow.f_19796_.m_188503_(70), pos.m_123342_(), pos.m_123343_() - 35 + this.voidShadow.f_19796_.m_188503_(70));
                    if (this.voidShadow.m_9236_().m_8055_(spawnPos.m_7495_()).m_60795_()) continue;
                    VoidFragmentEntity voidFragmentEntity = (VoidFragmentEntity)EntityInit.VOID_FRAGMENT.m_20615_(this.voidShadow.m_9236_());
                    voidFragmentEntity.m_6518_((ServerLevelAccessor)((ServerLevel)this.voidShadow.m_9236_()), this.voidShadow.m_9236_().m_6436_(pos), MobSpawnType.EVENT, null, null);
                    voidFragmentEntity.setVoidOrb(isOrb);
                    voidFragmentEntity.m_20035_(spawnPos, this.voidShadow.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                    this.voidShadow.m_9236_().m_7967_((Entity)voidFragmentEntity);
                    if (isOrb.booleanValue()) continue;
                    VoidCloudEntity voidCloudEntity = new VoidCloudEntity(this.voidShadow.m_9236_(), voidFragmentEntity.m_20185_(), voidFragmentEntity.m_20186_(), voidFragmentEntity.m_20189_());
                    int random = this.voidShadow.m_9236_().m_213780_().m_188503_(7) + 6;
                    voidCloudEntity.setRadius(random);
                    voidCloudEntity.setDuration(random * 140);
                    this.voidShadow.m_9236_().m_7967_((Entity)voidCloudEntity);
                }
                this.summonTick = 0;
                this.m_8041_();
            }
        }

        public void m_8056_() {
            this.voidShadow.f_19804_.m_135381_(HOVERING_MAGIC_HANDS, (Object)true);
            ((ServerLevel)this.voidShadow.m_9236_()).m_6269_(null, (Entity)this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, SoundSource.HOSTILE, 20.0f, 1.0f);
        }

        public void m_8041_() {
            this.voidShadow.f_19804_.m_135381_(HOVERING_MAGIC_HANDS, (Object)false);
            ((ServerLevel)this.voidShadow.m_9236_()).m_6269_(null, (Entity)this.voidShadow, SoundInit.SHADOW_CAST_EVENT, SoundSource.HOSTILE, 20.0f, 1.0f);
        }
    }

    static class SummonShade
    extends Goal {
        private final VoidShadowEntity voidShadow;
        private int summonStartTicker;
        private int summonTick;

        public SummonShade(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        public boolean m_8036_() {
            LivingEntity livingEntity = this.voidShadow.m_5448_();
            if (this.voidShadow.isInVoidDungeon && this.voidShadow.hasVoidMiddleCoordinates() && livingEntity != null) {
                ++this.summonStartTicker;
                if (this.summonStartTicker >= 80) {
                    AABB box = new AABB(this.voidShadow.m_20183_());
                    List list = this.voidShadow.m_9236_().m_6443_(VoidShadeEntity.class, box.m_82400_(120.0), EntitySelector.f_20408_);
                    if (list.size() < 6) {
                        return true;
                    }
                    this.summonStartTicker = 0;
                }
                return false;
            }
            return false;
        }

        public void m_8037_() {
            ++this.summonTick;
            if (this.summonTick >= 40 && this.voidShadow.m_5448_() != null) {
                BlockPos pos = this.voidShadow.getVoidMiddle();
                for (int i = 0; i < (this.voidShadow.isHalfLife ? 24 : 16); ++i) {
                    if (this.voidShadow.m_9236_().m_5776_()) continue;
                    BlockPos spawnPos = new BlockPos(pos.m_123341_() - 35 + this.voidShadow.f_19796_.m_188503_(70), pos.m_123342_(), pos.m_123343_() - 35 + this.voidShadow.f_19796_.m_188503_(70));
                    VoidShadeEntity voidShadeEntity = (VoidShadeEntity)EntityInit.VOID_SHADE.m_20615_(this.voidShadow.m_9236_());
                    voidShadeEntity.m_6518_((ServerLevelAccessor)((ServerLevel)this.voidShadow.m_9236_()), this.voidShadow.m_9236_().m_6436_(pos), MobSpawnType.EVENT, null, null);
                    voidShadeEntity.m_20035_(spawnPos, this.voidShadow.m_9236_().m_213780_().m_188501_() * 360.0f, 0.0f);
                    this.voidShadow.m_9236_().m_7967_((Entity)voidShadeEntity);
                }
                this.summonTick = 0;
                this.m_8041_();
            }
        }

        public void m_8056_() {
            this.voidShadow.f_19804_.m_135381_(HOVERING_MAGIC_HANDS, (Object)true);
            ((ServerLevel)this.voidShadow.m_9236_()).m_6269_(null, (Entity)this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, SoundSource.HOSTILE, 20.0f, 1.0f);
        }

        public void m_8041_() {
            this.voidShadow.f_19804_.m_135381_(HOVERING_MAGIC_HANDS, (Object)false);
            ((ServerLevel)this.voidShadow.m_9236_()).m_6269_(null, (Entity)this.voidShadow, SoundInit.SHADOW_CAST_EVENT, SoundSource.HOSTILE, 20.0f, 1.0f);
        }
    }

    static class Insanity
    extends Goal {
        private final VoidShadowEntity voidShadow;
        private int insanityStartTicker;
        private int tick;
        private static final TargetingConditions PLAYER_PREDICATE = TargetingConditions.m_148352_().m_26883_(80.0).m_148355_();
        private List<Player> playerList;

        public Insanity(VoidShadowEntity voidShadow) {
            this.voidShadow = voidShadow;
        }

        public boolean m_8036_() {
            if (this.voidShadow.isInVoidDungeon && this.voidShadow.circling && this.voidShadow.isHalfLife && this.voidShadow.hasVoidMiddleCoordinates() && this.voidShadow.blockPosList.isEmpty()) {
                ++this.insanityStartTicker;
                return this.insanityStartTicker >= 600;
            }
            return false;
        }

        public void m_8037_() {
            ++this.tick;
            this.voidShadow.m_6710_(null);
            if (this.tick == 60) {
                AABB box = new AABB(this.voidShadow.m_20183_());
                this.playerList = this.voidShadow.m_9236_().m_45955_(PLAYER_PREDICATE, (LivingEntity)this.voidShadow, box.m_82400_(120.0));
                for (int i = 0; i < this.playerList.size(); ++i) {
                    Player playerEntity = this.playerList.get(i);
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60 + this.voidShadow.f_19796_.m_188503_(80), this.voidShadow.f_19796_.m_188503_(4), false, false, true));
                    playerEntity.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 40 + this.voidShadow.f_19796_.m_188503_(60), 0, false, false, true));
                }
            }
            if (this.tick == 100) {
                int radius = 8;
                BlockPos pos = this.voidShadow.getVoidMiddle().m_7495_();
                for (int k = -radius; k <= radius; ++k) {
                    for (int i = -radius; i <= radius; ++i) {
                        BlockPos blockPos = pos.m_7918_(k, 0, i);
                        if (!(this.voidShadow.f_19796_.m_188501_() < 0.4f) || this.voidShadow.blockPosList.contains(blockPos) || this.voidShadow.m_9236_().m_8055_(blockPos).m_60795_() || this.voidShadow.m_9236_().m_8055_(blockPos).m_204336_(TagInit.UNBREAKABLE_BLOCKS)) continue;
                        this.voidShadow.blockPosList.add(blockPos);
                    }
                }
                for (int u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                    this.voidShadow.m_9236_().m_46597_(this.voidShadow.blockPosList.get(u), net.voidz.init.BlockInit.INFESTED_VOID.m_49966_());
                }
                ((ServerLevel)this.voidShadow.m_9236_()).m_6269_(null, (Entity)this.voidShadow, SoundInit.SHADOW_CAST_EVENT, SoundSource.HOSTILE, 20.0f, 1.0f);
            }
            if (this.tick >= 300) {
                if (this.voidShadow.m_21223_() < this.voidShadow.m_21233_() / 10.0f && !this.playerList.isEmpty()) {
                    for (int i = 0; i < this.playerList.size(); ++i) {
                        if (!(this.playerList.get(i) instanceof ServerPlayer)) continue;
                        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket(AdventureServerPacket.VELOCITY_PACKET, new FriendlyByteBuf(Unpooled.buffer().writeInt(this.playerList.get(i).m_19879_()).writeFloat(this.voidShadow.f_19796_.m_188501_() * 2.0f)));
                        ((ServerPlayer)this.playerList.get((int)i)).f_8906_.m_9829_((Packet)packet);
                    }
                    ((ServerLevel)this.voidShadow.m_9236_()).m_6269_(null, (Entity)this.voidShadow, SoundInit.SHADOW_IDLE_EVENT, SoundSource.HOSTILE, 20.0f, 1.0f);
                }
                this.tick = 0;
                this.m_8041_();
            }
        }

        public boolean m_8045_() {
            return this.insanityStartTicker >= 600;
        }

        public void m_8056_() {
            this.voidShadow.circling = false;
            this.voidShadow.wasCircling = true;
            this.voidShadow.f_21342_.m_6849_((double)this.voidShadow.getVoidMiddle().m_123341_(), (double)this.voidShadow.getVoidMiddle().m_123342_(), (double)this.voidShadow.getVoidMiddle().m_123343_(), 1.0);
            this.voidShadow.m_5997_(0.0, 0.2, 0.0);
            this.voidShadow.f_19804_.m_135381_(CIRCLING_HANDS, (Object)true);
            ((ServerLevel)this.voidShadow.m_9236_()).m_6269_(null, (Entity)this.voidShadow, SoundInit.SHADOW_PREPARE_EVENT, SoundSource.HOSTILE, 20.0f, 1.0f);
        }

        public void m_8041_() {
            this.voidShadow.circling = true;
            this.voidShadow.wasCircling = false;
            this.voidShadow.f_19804_.m_135381_(CIRCLING_HANDS, (Object)false);
            ((ServerLevel)this.voidShadow.m_9236_()).m_6269_(null, (Entity)this.voidShadow, SoundInit.SHADOW_CAST_EVENT, SoundSource.HOSTILE, 20.0f, 1.0f);
            this.insanityStartTicker = 0;
            for (int u = 0; u < this.voidShadow.blockPosList.size(); ++u) {
                this.voidShadow.m_9236_().m_46597_(this.voidShadow.blockPosList.get(u), net.voidz.init.BlockInit.VOID_STONE.m_49966_());
            }
            if (!this.playerList.isEmpty()) {
                this.playerList.clear();
            }
            if (!this.voidShadow.blockPosList.isEmpty()) {
                this.voidShadow.blockPosList.clear();
            }
        }
    }

    static class FlyGoal
    extends Goal {
        private final VoidShadowEntity voidShadowEntity;

        public FlyGoal(VoidShadowEntity voidShadowEntity) {
            this.voidShadowEntity = voidShadowEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double f;
            double e;
            MoveControl moveControl = this.voidShadowEntity.m_21566_();
            if (!(moveControl.m_24995_() && this.voidShadowEntity.m_5448_() == null || this.voidShadowEntity.circling)) {
                return true;
            }
            double d = moveControl.m_25000_() - this.voidShadowEntity.m_20185_();
            double g = d * d + (e = moveControl.m_25001_() - this.voidShadowEntity.m_20186_()) * e + (f = moveControl.m_25002_() - this.voidShadowEntity.m_20189_()) * f;
            return g < 1.0 || g > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            if (this.voidShadowEntity.m_5448_() != null && this.voidShadowEntity.m_20270_((Entity)this.voidShadowEntity.m_5448_()) > 30.0f) {
                BlockPos pos = this.voidShadowEntity.m_5448_().m_20183_();
                this.voidShadowEntity.m_21566_().m_6849_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 0.01);
            }
        }
    }

    static class LookGoal
    extends Goal {
        private final VoidShadowEntity voidShadowEntity;
        private static final TargetingConditions PLAYER_PREDICATE = TargetingConditions.m_148352_().m_26883_(80.0).m_148355_();

        public LookGoal(VoidShadowEntity voidShadowEntity) {
            this.voidShadowEntity = voidShadowEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.voidShadowEntity.circling && this.voidShadowEntity.hasVoidMiddleCoordinates()) {
                BlockPos pos = this.voidShadowEntity.getVoidMiddle();
                Vec3 vec3d = new Vec3((double)pos.m_123341_() - this.voidShadowEntity.m_20185_(), (double)pos.m_123342_() - this.voidShadowEntity.m_20186_(), (double)pos.m_123343_() - this.voidShadowEntity.m_20189_());
                this.voidShadowEntity.m_146922_(-((float)Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_)) * 57.295776f);
                this.voidShadowEntity.f_20883_ = this.voidShadowEntity.m_146908_();
                this.voidShadowEntity.m_6710_((LivingEntity)this.voidShadowEntity.m_9236_().m_45946_(PLAYER_PREDICATE, (LivingEntity)this.voidShadowEntity));
            } else if (this.voidShadowEntity.m_5448_() == null) {
                Vec3 vec3d = this.voidShadowEntity.m_20184_();
                this.voidShadowEntity.m_146922_(-((float)Mth.m_14136_((double)vec3d.f_82479_, (double)vec3d.f_82481_)) * 57.295776f);
                this.voidShadowEntity.f_20883_ = this.voidShadowEntity.m_146908_();
            } else {
                LivingEntity livingEntity = this.voidShadowEntity.m_5448_();
                if (livingEntity.m_20280_((Entity)this.voidShadowEntity) < 4096.0) {
                    double e = livingEntity.m_20185_() - this.voidShadowEntity.m_20185_();
                    double f = livingEntity.m_20189_() - this.voidShadowEntity.m_20189_();
                    this.voidShadowEntity.m_146922_(-((float)Mth.m_14136_((double)e, (double)f)) * 57.295776f);
                    this.voidShadowEntity.f_20883_ = this.voidShadowEntity.m_146908_();
                }
            }
        }
    }
}

